unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls;

type
  TForm1 = class(TForm)
    Edit1: TEdit;
    Button1: TButton;
    Label1: TLabel;
    ScrollBar1: TScrollBar;
    ScrollBar2: TScrollBar;
    Label2: TLabel;
    ScrollBar3: TScrollBar;
    ScrollBar4: TScrollBar;
    Label3: TLabel;
    Edit2: TEdit;
    procedure Button1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure Edit2Change(Sender: TObject);
    procedure ScrollBar1Change(Sender: TObject);
  private
    uchwytOkna :THandle;
    trwaOdczytywanieWlasnosciOkna :Boolean;
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

uses PobieranieUchwytuOkna;

{$R *.dfm}

{procedure TForm1.Button1Click(Sender: TObject);
const MAX_COUNT=256;
var
  ProcessId :Cardinal;
  //uchwytOkna :THandle;
  nazwaOkna :array[0..MAX_COUNT-1] of Char;
  ustawieniaOkna :TWindowPlacement;
  prawidlowyPID :Boolean;
  x,y,szer,wys :Integer;
begin
  trwaOdczytywanieWlasnosciOkna:=True;
  ProcessId:=0;
  try
    ProcessId:=StrToInt(Edit1.Text);
  except
    ShowMessage('Identyfikator procesu musi by liczb');
    Exit;
  end;

  uchwytOkna:=GetMainWindowHandle(ProcessId);
  prawidlowyPID:=uchwytOkna<>0;

  ScrollBar1.Enabled:=prawidlowyPID;
  ScrollBar2.Enabled:=prawidlowyPID;
  ScrollBar3.Enabled:=prawidlowyPID;
  ScrollBar4.Enabled:=prawidlowyPID;
  Edit2.Enabled:=prawidlowyPID;

  if prawidlowyPID then
    begin
    GetWindowText(uchwytOkna,nazwaOkna,MAX_COUNT);
    GetWindowPlacement(uchwytOkna,@ustawieniaOkna);

    x:=ustawieniaOkna.rcNormalPosition.Left;
    y:=ustawieniaOkna.rcNormalPosition.Top;
    szer:=ustawieniaOkna.rcNormalPosition.Right-x;
    wys:=ustawieniaOkna.rcNormalPosition.Bottom-y;

    //ujemna pozycja nie jest uwzgledniana
    ScrollBar1.Max:=Screen.Width;
    ScrollBar2.Max:=Screen.Height;
    ScrollBar3.Max:=Screen.Width;
    ScrollBar4.Max:=Screen.Height;
    ScrollBar1.Position:=szer;
    ScrollBar2.Position:=wys;
    ScrollBar3.Position:=x;
    ScrollBar4.Position:=y;
    Edit2.Text:=nazwaOkna;

    if Sender=Button1 then
    ShowMessage('Uchwyt okna: '+IntToStr(uchwytOkna)+Chr(13)+
                'Nazwa okna: '+nazwaOkna+Chr(13)+Chr(13)+
                'Polozenie okna: x='+IntToStr(x)+', y='+IntToStr(y)+Chr(13)+
                'Rozmiar okna: '+IntToStr(szer)+' x '+IntToStr(wys));
    end
    else
    ShowMessage('Proces o podanym numerze PID nie istnieje');

    trwaOdczytywanieWlasnosciOkna:=False;
  end;}

procedure TForm1.Button1Click(Sender: TObject);
const MAX_COUNT=256;
var
  ProcessId :Cardinal;
  ustawieniaOkna :TWindowPlacement;
  prawidlowyPID :Boolean;
  x,y,szer,wys :Integer;

  {$IF NOT DEFINED(CLR)} //Win32
  nazwaOkna :array[0..MAX_COUNT-1] of Char;
  {$ELSE} //.NET
  nazwaOkna :StringBuilder;
  {$IFEND}

begin
  trwaOdczytywanieWlasnosciOkna:=True;
  ProcessId:=0;
  try
    ProcessId:=StrToInt(Edit1.Text);
  except
    ShowMessage('Identyfikator procesu musi by liczb');
    Exit;
  end;

  uchwytOkna:=GetMainWindowHandle(ProcessId);
  prawidlowyPID:=uchwytOkna<>0;

  ScrollBar1.Enabled:=prawidlowyPID;
  ScrollBar2.Enabled:=prawidlowyPID;
  ScrollBar3.Enabled:=prawidlowyPID;
  ScrollBar4.Enabled:=prawidlowyPID;
  Edit2.Enabled:=prawidlowyPID;

  if prawidlowyPID then
    begin
    //Odczytywanie tytulu okna
    {$IF NOT DEFINED(CLR)} //Win32
    GetWindowText(uchwytOkna,nazwaOkna,MAX_COUNT);
    Edit2.Text:=nazwaOkna;
    {$ELSE} //.NET
    nazwaOkna:=StringBuilder.Create(MAX_COUNT);
    GetWindowText(uchwytOkna,nazwaOkna,MAX_COUNT);
    Edit2.Text:=nazwaOkna.ToString;
    {$IFEND}

    {$IF NOT DEFINED(CLR)} //Win32
    GetWindowPlacement(uchwytOkna,@ustawieniaOkna);
    {$ELSE} //.NET
    GetWindowPlacement(uchwytOkna,ustawieniaOkna);
    {$IFEND}

    x:=ustawieniaOkna.rcNormalPosition.Left;
    y:=ustawieniaOkna.rcNormalPosition.Top;
    szer:=ustawieniaOkna.rcNormalPosition.Right-x;
    wys:=ustawieniaOkna.rcNormalPosition.Bottom-y;

    //ujemna pozycja nie jest uwzgledniana
    ScrollBar1.Max:=Screen.Width;
    ScrollBar2.Max:=Screen.Height;
    ScrollBar3.Max:=Screen.Width;
    ScrollBar4.Max:=Screen.Height;
    ScrollBar1.Position:=szer;
    ScrollBar2.Position:=wys;
    ScrollBar3.Position:=x;
    ScrollBar4.Position:=y;

    if Sender=Button1 then
    ShowMessage('Uchwyt okna: '+IntToStr(uchwytOkna)+Chr(13)+
                'Nazwa okna: '+Edit2.Text+Chr(13)+Chr(13)+
                'Polozenie okna: x='+IntToStr(x)+', y='+IntToStr(y)+Chr(13)+
                'Rozmiar okna: '+IntToStr(szer)+' x '+IntToStr(wys));
    end
    else
    ShowMessage('Proces o podanym numerze PID nie istnieje');

    trwaOdczytywanieWlasnosciOkna:=False;
  end;

procedure TForm1.FormCreate(Sender: TObject);
begin
uchwytOkna:=0;
trwaOdczytywanieWlasnosciOkna:=False;
Edit1.Text:=IntToStr(GetCurrentProcessId());
end;

procedure TForm1.Edit2Change(Sender: TObject);
begin
{$IF NOT DEFINED(CLR)} //Win32
SetWindowText(uchwytOkna,PChar(Edit2.Text));
{$ELSE} //.NET
SetWindowText(uchwytOkna,Edit2.Text);
{$IFEND}
end;

procedure TForm1.ScrollBar1Change(Sender: TObject);
var
  ustawieniaOkna :TWindowPlacement;
begin
  if (uchwytOkna=0) or trwaOdczytywanieWlasnosciOkna then Exit;
  ustawieniaOkna.rcNormalPosition.Left:=ScrollBar3.Position;
  ustawieniaOkna.rcNormalPosition.Top:=ScrollBar4.Position;
  ustawieniaOkna.rcNormalPosition.Right:=ScrollBar3.Position+ScrollBar1.Position;
  ustawieniaOkna.rcNormalPosition.Bottom:=ScrollBar4.Position+ScrollBar2.Position;
  ustawieniaOkna.showCmd:=Integer(SW_RESTORE);
  ustawieniaOkna.length:=SizeOf(ustawieniaOkna);
  {$IF NOT DEFINED(CLR)} //Win32
  SetWindowPlacement(uchwytOkna,@ustawieniaOkna);
  {$ELSE} //.NET
  SetWindowPlacement(uchwytOkna,ustawieniaOkna);
  {$IFEND}
end;

end.
